#include <u.h>
#include <libc.h>
#include <draw.h>

#include "dat.h"
#include "fns.h"

// Inspired by /sys/src/games/doom/i_video.c:/^convproc
// and /sys/src/cmd/page.c:/^zoomdraw
// Thanks sigrid!
int
resizeimage(Image * di, Rectangle dr, float scale, Image * si, Point sp)
{
	float i;
	int c, sh;
	Image * t, * ci;

	if (scale < 0) {
		werrstr("scale < 0");
		return -1;
	} else if (scale == 1) {
		draw(di, dr, si, nil, addpt(sp, dr.min));
		return 1;
	}

	sh = Dy(si->r);
	if ((t = allocimage(display, dr, si->chan, 1, DNofill)) == nil) {
		werrstr("allocimage: %r");
		return -1;
	}

	if ((ci = allocimage(display, Rect(0, 0, 1, sh), si->chan, 1, DNofill)) == nil) {
		werrstr("allocimage: %r");
		freeimage(t);
		return -1;
	}

	for (i = dr.min.x; (int)(i) < dr.max.x; i+=scale) {
		draw(ci, ci->r, si, nil, addpt(sp, Pt((int)(i)/scale, dr.min.y/scale)));
		draw(t, Rect((int)(i), dr.min.y, (int)(i + scale), dr.max.y), ci, nil, ZP);
	}
	freeimage(ci);
	
	if ((ci = allocimage(display, Rect(0, 0, Dx(dr), 1), si->chan, 1, DNofill)) == nil) {
		werrstr("allocimage: %r");
		freeimage(t);
		return -1;
	}
	c = dr.min.y;
 	for (i = dr.min.y; i < dr.max.y; i+=scale) {
		draw(ci, ci->r, t, nil, Pt(dr.min.x, c++));
 		draw(di, Rect(dr.min.x, i, dr.max.x, i + scale), ci, nil, ZP);
	}

	freeimage(t);
	freeimage(ci);

	return 1;
}
