#include <u.h>
#include <libc.h>
#include <draw.h>
#include <thread.h>
#include <mouse.h>
#include <keyboard.h>
#include <cursor.h>

#define EventsReady()	(keyboardctl != nil && mousectl != nil)
#define CheckEventsReady() if(!EventsReady()) { werrstr(Enotready); return -1; }

#include "dat.h"
#include "fns.h"

static Events events = {0};
static Keyboardctl * keyboardctl = nil;
static Mousectl * mousectl = nil;
static char * Enotready = "events not initialized";

int
eventsread(Events * events)
{
	Rune k[20];

	CheckEventsReady();
	if (events == nil) {
		werrstr("events must not be nil");
		return -1;
	}

// 	if (keyboardctl->c != nil || recv(keyboardctl->c, k))
// 		return -1;

	events->keys = k[0];

	if (readmouse(mousectl) < 0)
		return -1;
	events->mouse = *mousectl;

	return 1;
}

void
eventsclose()
{
	if (keyboardctl != nil)
		closekeyboard(keyboardctl);
	keyboardctl = nil;
	
	if (mousectl != nil)
		closemouse(mousectl);
	mousectl = nil;
}

int
eventsinit(void)
{
	if (keyboardctl != nil && mousectl != nil)
		return -1;
	
	if ((mousectl = initmouse(nil, screen)) == nil)
		return -1;
	if ((keyboardctl = initkeyboard(nil)) == nil ||
		(ctlkeyboard(keyboardctl, "rawon")) < 0) {
		eventsclose();
		return -1;
	}
	

	return 1;
}