typedef struct Layer
{
 	Image * image;
 	struct Layer * prev, * next;
	int changed, id;
	Point offset;
} Layer;

enum
{
	BMouse,
	BKeyboard
};
enum
{
	BEleave,
	BEenter,
	BEin,
};

typedef struct Binding
{
	struct Binding * prev, * next;
	int code;
	int type;
	int state;
	int pressed, lastPressed;
	char * command;
	void (*func)(int);
} Binding;

typedef struct Task
{
	ulong start;
	void (*func)(void);
} Task;

// extern Rectangle CanvasSize = {0};
// extern Point CanvasAt = {0};
extern Layer * LayerRoot;
extern Layer * CurrentLayer;
extern Binding * BindingRoot;
extern Image * ViewImage;
extern int RunLoop;
extern int ZoomSensitivity;
extern Point MousePosition;
extern Point PastMousePosition;
extern Point CanvasAt;
extern int CanvasMoved;
extern int DrawAllLayers;
extern ulong LastUpdate;
extern int TargetZoom;
// extern Layer * CurrentLayer = nil;
// extern Image * Background = nil;
// extern Image * Canvas = nil;
